<?php

/**
 * Class that operate on table 'restaurantorderdeliverydetails'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-12-04 14:10
 */
class RestaurantorderdeliverydetailsMySqlDAO implements RestaurantorderdeliverydetailsDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return RestaurantorderdeliverydetailsMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM restaurantorderdeliverydetails WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM restaurantorderdeliverydetails';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM restaurantorderdeliverydetails ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param restaurantorderdeliverydetail primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM restaurantorderdeliverydetails WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param RestaurantorderdeliverydetailsMySql restaurantorderdeliverydetail
     */
    public function insert($restaurantorderdeliverydetail) {
        $sql = 'INSERT INTO restaurantorderdeliverydetails (orderId, clientId, clientmobile, clientphone, clientaddress, clientdetails,driverId,driverReciveDate,deliveryStatus) VALUES (?, ?, ?, ?, ?, ?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($restaurantorderdeliverydetail->orderId);
        $sqlQuery->setNumber($restaurantorderdeliverydetail->clientId);
        $sqlQuery->setNumber($restaurantorderdeliverydetail->clientmobile);
        $sqlQuery->setNumber($restaurantorderdeliverydetail->clientphone);
        $sqlQuery->setNumber($restaurantorderdeliverydetail->clientaddress);
        $sqlQuery->setNumber($restaurantorderdeliverydetail->clientdetails);
        $sqlQuery->setNumber($restaurantorderdeliverydetail->driverId);
        $sqlQuery->set($restaurantorderdeliverydetail->driverReciveDate);
        $sqlQuery->setNumber($restaurantorderdeliverydetail->deliveryStatus);

        $id = $this->executeInsert($sqlQuery);
        $restaurantorderdeliverydetail->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param RestaurantorderdeliverydetailsMySql restaurantorderdeliverydetail
     */
    public function update($restaurantorderdeliverydetail) {
        $sql = 'UPDATE restaurantorderdeliverydetails SET orderId = ?, clientId = ?, clientmobile = ?, clientphone = ?, clientaddress = ?, clientdetails = ?, driverId=?, driverReciveDate=?, deliveryStatus=? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($restaurantorderdeliverydetail->orderId);
        $sqlQuery->setNumber($restaurantorderdeliverydetail->clientId);
        $sqlQuery->setNumber($restaurantorderdeliverydetail->clientmobile);
        $sqlQuery->setNumber($restaurantorderdeliverydetail->clientphone);
        $sqlQuery->setNumber($restaurantorderdeliverydetail->clientaddress);
        $sqlQuery->setNumber($restaurantorderdeliverydetail->clientdetails);
        $sqlQuery->setNumber($restaurantorderdeliverydetail->driverId);
        $sqlQuery->set($restaurantorderdeliverydetail->driverReciveDate);
        $sqlQuery->setNumber($restaurantorderdeliverydetail->deliveryStatus);

        $sqlQuery->setNumber($restaurantorderdeliverydetail->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM restaurantorderdeliverydetails';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByOrderId($value) {
        $sql = 'SELECT * FROM restaurantorderdeliverydetails WHERE orderId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientId($value) {
        $sql = 'SELECT * FROM restaurantorderdeliverydetails WHERE clientId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientmobile($value) {
        $sql = 'SELECT * FROM restaurantorderdeliverydetails WHERE clientmobile = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientphone($value) {
        $sql = 'SELECT * FROM restaurantorderdeliverydetails WHERE clientphone = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientaddress($value) {
        $sql = 'SELECT * FROM restaurantorderdeliverydetails WHERE clientaddress = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientdetails($value) {
        $sql = 'SELECT * FROM restaurantorderdeliverydetails WHERE clientdetails = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByOrderId($value) {
        $sql = 'DELETE FROM restaurantorderdeliverydetails WHERE orderId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientId($value) {
        $sql = 'DELETE FROM restaurantorderdeliverydetails WHERE clientId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientmobile($value) {
        $sql = 'DELETE FROM restaurantorderdeliverydetails WHERE clientmobile = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientphone($value) {
        $sql = 'DELETE FROM restaurantorderdeliverydetails WHERE clientphone = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientaddress($value) {
        $sql = 'DELETE FROM restaurantorderdeliverydetails WHERE clientaddress = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientdetails($value) {
        $sql = 'DELETE FROM restaurantorderdeliverydetails WHERE clientdetails = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return RestaurantorderdeliverydetailsMySql
     */
    protected function readRow($row) {
        $restaurantorderdeliverydetail = new Restaurantorderdeliverydetail();

        $restaurantorderdeliverydetail->id = $row['id'];
        $restaurantorderdeliverydetail->orderId = $row['orderId'];
        $restaurantorderdeliverydetail->clientId = $row['clientId'];
        $restaurantorderdeliverydetail->clientmobile = $row['clientmobile'];
        $restaurantorderdeliverydetail->clientphone = $row['clientphone'];
        $restaurantorderdeliverydetail->clientaddress = $row['clientaddress'];
        $restaurantorderdeliverydetail->clientdetails = $row['clientdetails'];
        $restaurantorderdeliverydetail->driverId = $row['driverId'];
        $restaurantorderdeliverydetail->driverReciveDate = $row['driverReciveDate'];
        $restaurantorderdeliverydetail->deliveryStatus = $row['deliveryStatus'];

        return $restaurantorderdeliverydetail;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return RestaurantorderdeliverydetailsMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>